state RockWatcherSpells in W3MagicVigil
{
	var damage_action			 						: W3DamageAction;
	var damage_value									: float;
	var actors 											: array<CActor>;
	var i												: int;
	var main_effect, effect_entity  					: CEntity;
	var target											: CActor; 
	var entities 										: array<CGameplayEntity>; 
	var position 										: Vector;
	var rotation 										: EulerAngles;
	var slotMatrix 										: Matrix;
	var permafrost_trap   								: W3PermafrostTrap;
	var ents_destroy									: array< CEntity >;
	var duration										: float;
	var CustomEffect									: SCustomEffectParams;
	var castDir											: Vector;
	var targetPosition									: Vector;
	var icespear										: W3PermafrostSpear;
	var dummy											: CEntity;
	var dummy_proj                                      : W3PermafrostDummy;
	var vector_attach 									: Vector;
	var proj 											: W3SpellsStoneProj;
	
	event OnEnterState( prevStateName : name )
	{
		if ( !theSound.SoundIsBankLoaded("monster_golem_dao.bnk") )
		{
			theSound.SoundLoadBank( "monster_golem_dao.bnk", false );
		}
	
		if ( parent.act_signtype == ST_Axii )
		{
			if ( parent.actor && parent.actor.IsAlive() )
			{
				thePlayer.SetSlideTarget( parent.actor );
			}
			else
			{
				thePlayer.AddCustomOrientationTarget( OT_CameraOffset, 'MagicSpells' );
			}
		}
		else
		if ( !theGame.GetInGameConfigWrapper().GetVarValue('magic_spells_main', 'cast_to_camera') )
		{
			if ( !GetMagicVigil().IsAlt() )
			{
				if ( parent.actor && parent.actor.IsAlive() )
				{
					thePlayer.SetSlideTarget( parent.actor );
				}
				else
				{
					thePlayer.AddCustomOrientationTarget( OT_CameraOffset, 'MagicSpells' );
				}
			}
		}
		else
		{
			thePlayer.AddCustomOrientationTarget( OT_CameraOffset, 'MagicSpells' );
		}
		
		golem_stone_precast();
	}
	
	event OnCastSpellAnimation( animEventName : name, animEventType : EAnimationEventType, animInfo : SAnimationEventAnimInfo )
	{
		if ( animEventName == 'cast_begin' )
		{	
		}
		else if ( animEventName == 'cast_throw' )
		{
			cast_spells_axii_rockwatcher_init();
			cast_spells_rockwatcher();
			thePlayer.RemoveCustomOrientationTarget( 'MagicSpells' );
		}
		else if ( animEventName == 'cast_end' )
		{
			cast_spells_axii_rockwatcher();
			//parent.GotoState( 'Vigil_Dreaming' );
		}
	}
	
	private entry function golem_stone_precast()
	{
		var portal				: CEntity;
		var newPos				: Vector;
		
		if ( parent.spell_name == 'stone_golem' )
		{
			position = thePlayer.GetWorldPosition() + thePlayer.GetWorldForward()*2.5;
			position = find_position_spells( position );	
			if( !theGame.GetWorld().NavigationFindSafeSpot( position, 1, 1, newPos ) )
			{
				theGame.GetGuiManager().ShowNotification( GetLocStringByKeyExt( "menu_cannot_perform_action_here" ),, true );
				parent.GotoState( 'Vigil_Dreaming' );
			}
			else
			{
				Sleep(0.3);
				position.Z += 2;
				
				portal = theGame.CreateEntity( (CEntityTemplate)LoadResource( "dlc\magicspellsrev\data\entities\portal_for_golems.w2ent", true ), position );
				portal.PlayEffect('teleport');
				portal.StopAllEffects();
				portal.DestroyAfter( 1.5 );
			}
		}
	}
	
	private function cast_spells_rockwatcher()
	{
		var stone_line 			: W3RockwatcherLine;
		var newPos				: Vector;
		var portal				: CEntity;
		var golem_npc 			: CNewNPC;
		var bonusAbilityName	: name;
		var pillar				: W3SpellsRockPillar;
	
		switch( parent.spell_name )
		{
			case 'stone_area':
				{
					thePlayer.SoundEvent("monster_golem_dao_cmb_swoosh_light");
				
					effect_entity = (CEntity)theGame.CreateEntity( (CEntityTemplate)LoadResource( 'rockwatcher_effects' ), thePlayer.GetWorldPosition() ) ;
					effect_entity.CreateAttachment( thePlayer, 'l_weapon' );
					effect_entity.PlayEffect( 'rockwatcher_circle' );
					effect_entity.StopEffect( 'rockwatcher_circle' );
					effect_entity.DestroyAfter(5);
				
					actors = thePlayer.GetNPCsAndPlayersInRange( 7, 100, , FLAG_Attitude_Hostile + FLAG_OnlyAliveActors );
					for( i = 0; i < actors.Size(); i += 1 )
					{
						if ( IsRequiredAttitudeBetween(thePlayer, actors[i], true, false, false) )
						{ 
							parent.templatename = "dlc\magicspellsrev\data\entities\rockwatcher_pillar.w2ent";
							
							pillar = (W3SpellsRockPillar)theGame.CreateEntity( (CEntityTemplate)LoadResource( parent.templatename ,true ), actors[i].PredictWorldPosition( 0.5 ),
																																		   actors[i].GetWorldRotation()	);
							pillar.PlayEffect('circle_stone');
							pillar.DestroyAfter(5);
						}
					}
					
					Spells_drain_stamina( parent.stamina_cost, parent.stamina_delay, parent.signskill );
					parent.GotoState( 'Vigil_Dreaming' );
				}

				break;
			case 'stone_golem':
				{
					parent.destroy_stone_golems();
					
					duration = 15;
					duration += duration * ( GetMagicVigil().get_magic_spellpower() * 0.5 );
					
					position.Z -= 1;
					
					main_effect = theGame.CreateEntity( (CEntityTemplate)LoadResource( 'dao' ), position, thePlayer.GetWorldRotation() );
					main_effect.AddTag( 'spells_stone_golem' );
					golem_npc = (CNewNPC)main_effect;
					golem_npc.AddTag( 'spells_stone_golem_npc' );
					golem_npc.SetAttitude( thePlayer, AIA_Friendly );
					
					bonusAbilityName = thePlayer.GetSkillAbilityName(S_Magic_s05);
					for(i=0; i<=3; i+=1)
					{
						golem_npc.AddAbility(bonusAbilityName, true);
					}
					parent.AddTimer( 'destroy_summoned_stone_golem', duration );
					parent.AddTimer( 'evaluate_targets_for_stone_golem', 0.3, true);
					
					Spells_drain_stamina( parent.stamina_cost, parent.stamina_delay, parent.signskill );
					
					parent.GotoState( 'Vigil_Dreaming' );
				}

				break;
			case 'stone_line':
				{
					thePlayer.CalcEntitySlotMatrix('l_weapon', slotMatrix);
					position = MatrixGetTranslation(slotMatrix);
					rotation = MatrixGetRotation(slotMatrix);
						
					castDir 		= MatrixGetAxisX( slotMatrix );
					castDir.Z 		= ClampF( castDir.Z, 0, 10 );
					targetPosition 	= position + ( 5 * castDir );
						
					parent.hand_aim_position = position;
					parent.hand_aim_direction = castDir;
						
					rotation.Roll = ClampF(rotation.Roll,-100,10);
					
					parent.templatename = "dlc\magicspellsrev\data\entities\rockwatcher_stoneline.w2ent";
					
			
					stone_line = (W3RockwatcherLine)theGame.CreateEntity( (CEntityTemplate)LoadResource( parent.templatename, true ), position, rotation );
					stone_line.AddTag( 'spells_custom_projs' );
					stone_line.Init(NULL);
					stone_line.ShootProjectileAtPosition(0,	15, targetPosition, 20 );
					stone_line.DestroyAfter(10);
					
					Spells_drain_stamina( parent.stamina_cost, parent.stamina_delay, parent.signskill );
					parent.GotoState( 'Vigil_Dreaming' );
				}
				
				break;
			default:		
				break;
		}
		
	}
	
	
	private entry function cast_spells_axii_rockwatcher_init()
	{
		if ( parent.spell_name == 'stone_projectile' )
		{
			vector_attach = Vector( -0.2, 0.07, 0.05 );
		
			effect_entity = (CEntity)theGame.CreateEntity( (CEntityTemplate)LoadResource( 'rockwatcher_effects' ), thePlayer.GetWorldPosition() ) ;
			effect_entity.CreateAttachment( thePlayer, 'l_weapon', vector_attach );
			effect_entity.PlayEffect( 'rockwatcher_shot' );
			effect_entity.StopEffect( 'rockwatcher_shot' );
			effect_entity.DestroyAfter(5);
			
			thePlayer.SoundEvent("monster_golem_dao_mv_foley_heavy");
			thePlayer.SoundEvent("monster_golem_dao_mv_foley_light");
		}
	}
	private function cast_spells_axii_rockwatcher()
	{
		if ( parent.spell_name == 'stone_projectile' )
		{
			if ( parent.actor && parent.actor.IsAlive() && IsRequiredAttitudeBetween(thePlayer, parent.actor, true, false, false) )
			{
				
				targetPosition = parent.actor.GetBoneWorldPosition( spells_get_pelvis_name( parent.actor ) );
				targetPosition.Z += 0.3;
			
				parent.templatename = "dlc\magicspellsrev\data\entities\rockwatcher_stone_proj.w2ent";
				
				proj = (W3SpellsStoneProj)theGame.CreateEntity( (CEntityTemplate)LoadResource( parent.templatename, true ), thePlayer.GetWorldPosition() );
				proj.AddTag( 'spells_custom_projs' );
				proj.AddTag( 'spells_from_sign' );
				proj.PlayEffect('glow');
				proj.Init(NULL);
				proj.CreateAttachment( thePlayer, 'l_weapon', vector_attach );
				proj.BreakAttachment();
				proj.ShootProjectileAtPosition(0, 15, targetPosition );
				proj.DestroyAfter(10);
				
				Spells_drain_stamina( parent.stamina_cost, parent.stamina_delay, parent.signskill );
				
				thePlayer.SetCombatIdleStance( 1.f );
			}
			parent.GotoState( 'Vigil_Dreaming' );
		}
	}
	
	event OnLeaveState( nextStateName : name )
	{
	}
}